---
categorie: notitie
tags:
  - template
  - uitleg
---

## Doel van deze indeling

Deze indeling is ontworpen om een krachtig, samenhangend en doorzoekbaar notitiesysteem op te bouwen in Obsidian, gebaseerd op de **Zettelkasten-methode**. Elke template vertegenwoordigt een specifiek type notitie met vaste eigenschappen (frontmatter), zoals type notitie, school van gedachte (stroming) en bron. Dit maakt je notities consistent, linkbaar en makkelijk terug te vinden.

Het uiteindelijke doel: een persoonlijk kennisnetwerk waarin **personen, theorieën, begrippen, onderzoeken en stoornissen** verbonden zijn en overzichtelijk worden gepresenteerd.

1. Persoon
2. Theorie
3. Begrip
4. Onderzoek
5. Stoornis
6. Bron
7. Overzicht
8. Handleiding
9. Behandeling

---

## 1. Persoon

**Wat:** Belangrijke psychologen, onderzoekers of invloedrijke figuren.  
**Waarom:** Om inzicht te krijgen in wie ideeën en theorieën heeft ontwikkeld, en om verbanden tussen denkers te leggen.  
**Voorbeelden:** Sigmund Freud, B.F. Skinner, Jean Piaget.

**Frontmatter-ideeën:**

- type: Persoon
    
- geboortejaar / sterfjaar
    
- stroming
    
- belangrijke werken
    

---

## 2. Theorie

**Wat:** Centrale psychologische theorieën.  
**Waarom:** Om conceptuele kaders en verklaringen te organiseren, en om verbanden tussen theorieën te zien.  
**Voorbeelden:** Psychoanalyse, Behaviorisme, Cognitieve Dissonantie Theorie.

**Frontmatter-ideeën:**

- type: Theorie
    
- grondlegger(s)
    
- stroming
    
- kernideeën
    
- belangrijke publicaties
    

---

## 3. Begrip

**Wat:** Specifieke termen, concepten of definities binnen psychologie.  
**Waarom:** Dit is het bouwblok van je kennisnetwerk; elk begrip kan gekoppeld worden aan personen, theorieën of onderzoeken.  
**Voorbeelden:** Operante conditionering, Ego, Confirmation Bias.

**Frontmatter-ideeën:**

- type: Begrip
    
- definitie
    
- gerelateerde theorieën
    
- gerelateerde personen
    
- voorbeelden
    

---

## 4. Onderzoek

**Wat:** Belangrijke studies of experimenten.  
**Waarom:** Om empirisch bewijs te koppelen aan theorieën en begrippen, en om de methodologie van psychologie te begrijpen.  
**Voorbeelden:** Milgram’s gehoorzaamheidsexperiment, Stanford Prison Experiment.

**Frontmatter-ideeën:**

- type: Onderzoek
    
- onderzoekers
    
- jaar
    
- methode
    
- belangrijkste bevindingen
    
- gekoppelde theorieën / begrippen
    

---

## 5. Stoornis

**Wat:** Klinische diagnoses of psychische aandoeningen, zoals gedefinieerd in bijvoorbeeld DSM-5.  
**Waarom:** Om een overzicht te hebben van symptomen, diagnostische criteria en behandelmethoden.  
**Voorbeelden:** Major Depressive Disorder, Obsessive-Compulsive Disorder.

**Frontmatter-ideeën:**

- type: Stoornis
    
- symptomen
    
- DSM-5 classificatie
    
- gerelateerde theorieën / onderzoeken
    

---

## 6. Bron

**Wat:** Boeken, artikelen of colleges waar je informatie uit haalt.  
**Waarom:** Om de oorsprong van kennis te kunnen traceren en referenties consistent te houden.  
**Voorbeelden:** "Thinking, Fast and Slow" – Daniel Kahneman.

**Frontmatter-ideeën:**

- type: Bron
    
- auteur
    
- jaar
    
- type publicatie
    
- link / DOI
    
- notities
    

---

## 7. Overzicht

**Wat:** Een overzichts- of samenvattingspagina over een breder onderwerp.  
**Waarom:** Organiseert en linkt je bestaande notities (Begrip, Theorie, Persoon, etc.) zodat je het geheel kunt overzien zonder te verdwalen in details. Dit is cruciaal in de Zettelkasten-methode.

**Frontmatter-ideeën:**
- type: Overzicht
- onderwerp
- gerelateerde notities
- samenvatting / kernpunten
    
---

## 8. Handleiding

**Wat:** Een praktische gids of stappenplan voor het uitvoeren van een taak of interventie.  
**Waarom:** Om duidelijke instructies te hebben voor het toepassen van interventies, methoden of processen. Helpt consistentie en herhaalbaarheid te waarborgen.  
**Voorbeelden:** “4-stappenplan bij interventies”, “Handleiding voor observatie van kinderen”.

**Frontmatter-ideeën:**
- type: Handleiding
- doel
- doelgroep
- toepassing / context
- stappenplan
- voorbeelden
- evaluatie / reflectie
- bronnen & referenties
    

---

## 9. Behandeling

**Wat:** Een methodische interventie of therapie gericht op een specifiek probleem of stoornis.  
**Waarom:** Om klinische of praktische interventies systematisch te documenteren, inclusief indicaties, uitvoering en effectiviteit. Helpt bij kennisoverdracht en inzicht in therapeutische aanpakken.  
**Voorbeelden:** Cognitieve gedragstherapie bij angststoornissen, EMDR bij trauma, Mindfulness-based stress reduction.

**Frontmatter-ideeën:**
- type: Behandeling
- doel
- indicatie (bij welke stoornis/probleem toepasbaar)
- werkwijze / stappen
- effectiviteit
- mogelijke bijwerkingen / beperkingen
- gerelateerde stoornis / theorie / alternatieve behandelingen
- bronnen & referenties
    

---

# Over Frontmatter

**Frontmatter** is een stukje metadata dat je bovenaan een notitie in **Obsidian** (of andere Markdown-gebaseerde systemen) kunt plaatsen. Het staat tussen twee sets van drie streepjes `---` en bevat informatie over de notitie die niet direct in de hoofdtekst staat, maar gebruikt kan worden voor sorteren, filteren, en linken.

### Wat het doet

- **Type notitie aangeven**: bijvoorbeeld `type: Theorie` of `type: Persoon`.
    
- **Extra eigenschappen opslaan**: zoals auteur, jaartal, stroming, bron, gerelateerde notities.
    
- **Automatisch organiseren en filteren**: Obsidian-plugins kunnen deze data gebruiken om lijsten, dashboards of zoekfilters te maken.
    

### Voorbeeld in Obsidian

```


--- 
type: Theorie 
grondlegger: Sigmund Freud 
stroming: Psychoanalyse 
jaar: 1900 
belangrijkste_werken: "De droomduiding" 
--- 

Hier komt de inhoud van de notitie, bijvoorbeeld een samenvatting van de theorie.

```

### Simpele uitleg

Je kunt het zien als **een soort “identiteitskaart” voor je notitie**: het vertelt Obsidian (en jezelf) wat voor soort notitie het is en welke kenmerken belangrijk zijn, zonder dat het in de hoofdtekst staat.

Als je wilt, kan ik een **lijst maken van handige frontmatter-velden voor alle psychologie-notities** zodat je ze meteen kunt toepassen in je templates. Wil je dat ik dat doe?